#!/usr/bin/env bash
# If you are executing this script in cron with a restricted environment,
# modify the shebang to specify appropriate path; /bin/bash in most distros.
# And, also if you aren't comfortable using(abuse?) env command.

# This script is based on https://serverfault.com/a/767079 posted
# by Mike Blackwell, modified to our needs. Credits to the author.

# This script is called from systemd unit file to mount or unmount
# a USB drive.
source /usr/local/bin/bash-logger.sh
export LOGFILE=/var/log/usb-mount.log
ERROR()     { LOG_HANDLER_DEFAULT "$FUNCNAME" "$@"; }
CRITICAL()  { LOG_HANDLER_DEFAULT "$FUNCNAME" "$@"; }
ALERT()     { LOG_HANDLER_DEFAULT "$FUNCNAME" "$@"; }
EMERGENCY() { LOG_HANDLER_DEFAULT "$FUNCNAME" "$@"; }




PATH="$PATH:/usr/bin:/usr/local/bin:/usr/sbin:/usr/local/sbin:/bin:/sbin"

ACTION=$1
DEVBASE=$2
DEVICE="/dev/${DEVBASE}"
MOUNT_POINT=$(udisksctl info -b ${DEVICE} | grep MountPoints:  | awk '{ print $2 }')

LOG_HANDLER_DEFAULT() {
    local formatted_log="$(FORMAT_LOG "$@")"
    LOG_HANDLER_COLORTERM "$1" "$formatted_log"
    LOG_HANDLER_LOGFILE "$1" "$formatted_log"
    echo "logged to logfile"
}

do_umount()
{
        INFO "<${ACTION} - ${DEVICE}> ${MOUNT_POINT}"
	MOUNT_POINT=$(udisksctl info -b ${DEVICE} | grep MountPoints:  | awk '{ print $2 }')

        if [ -z ${MOUNT_POINT} ]; then
		INFO "${DEVICE} IS A UNIT"
	else

	        if ! udisksctl unmount -b ${DEVICE} ; then
			ERROR "ERROR UNMOUNTING ${DEVICE} (STATUS = $?)"
	                exit 1
		else
			INFO "${DEVICE} UNMOUNTED AT ${MOUNT_POINT}"
	        fi
        fi
	INFO "</${ACTION} - ${DEVICE}>"
}
case "${ACTION}" in
    remove)
        do_umount
        ;;
esac



/usr/local/bin/usb-mount-sleep.sh $ACTION $DEVBASE & disown
