#!/bin/bash

# temporary file
TEMP=/tmp/answer$$
PATH="$PATH:/usr/bin:/usr/local/bin:/usr/sbin:/usr/local/sbin:/bin:/sbin"

ADDRESS_KEY="bind-address"
COMMENT_ADDRESS_KEY="#bind-address"
EXTERNAL_LOCKING="skip-external-locking"
COMMENT_EXTERNAL_LOCKING="#skip-external-locking"
CONFIG_FILE="/etc/mysql/mysql.conf.d/mysqld.cnf"
EXPORTS_FILE="/etc/exports"
DOCKER_CONFIG_FILE="/lib/systemd/system/docker.service"
DOCKER_START="ExecStart"
DOCKER_START_REPLACE="/usr/bin/dockerd -H tcp://0.0.0.0:3000 -H fd://"
LSYNCD_CONFIG="/etc/lsyncd/lsyncd.conf.lua"
ROOT_PWD=""
RETYPE_ROOT_PWD=""
SSH_CONFIG_FILE="/etc/ssh/sshd_config"
SSH_PERMIT="PermitRootLogin"
SSH_PERMIT_REPLACE="yes"
THEATER_NUMBER=""
SAMBA_CONFIG_FILE="/etc/samba/smb.conf"

PROFTPD_CONFIG_FILE="/etc/proftpd/proftpd.conf"
DEFAULT_FTP_ROOT="# DefaultRoot"
DEFAULT_FTP_ROOT_SPACE="DefaultRoot"
REPLACE_DEFAULT_FTP_ROOT="/datastore"

disclaimer() {
	dialog --title "ATTENTION!!"  --yesno "The installation of the datastores has a preferred sequence, first the secondary datastores then the primary datastore. By primary datastore we mean the datastore from which the synchronization starts, the secondary datastore is the datastore where the files arrive from the synchronization. During installation of the secondary datastore, the SSH connection is enabled for the root user required for the primary datastore. During installation of the primary datastore, SSH access keys for each secondary datastore required for synchronization are also created in addition to enabling SSH for the root user.
	
Do you want to continue with the installation?" 15 100
	retv=$?
	if [ $retv -eq 1 -o $retv -eq 255 ]; then
	clean_up
	fi
}	

install_prerequisite() {

#	dialog --title "Theater's Number" --inputbox  "Enter the maximum theater number will be installed [e.g 1 2 3 ...]" 8 50  2>$TEMP

	retv=$?
	THEATER_NUMBER=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1

	dialog --infobox "Install prerequisite, please wait" 3 40


        echo -e "\e[1;34mInstallation prerequisite\e[0m"

        apt-get -y update
	apt-get -y upgrade
	autoremove
        apt-get install -y software-properties-common
        add-apt-repository -y ppa:ondrej/php

	apt-get -qq install build-essential
	apt-get -qq install ibprotobuf-dev protobuf-compiler libprotobuf-c-dev 	libprotobuf-c1 	libprotobuf-c1-dbg protobuf-c-compiler
	apt-get -qq install curl libcurl3 libcurl3-gnutls libcurl4-gnutls-dev libxml2 libxml2-dbg libxml2-dev libxml2-utils
	apt-get -qq install openssl libssl-dev openssh-client openssh-server
	apt-get -qq install net-tools iftop
	apt-get -qq install apache2
	apt-get -qq install php7.0 libapache2-mod-php7.0 php7.0-mcrypt php7.0-mysql php7.0-xml php7.0-dev php-ssh2 php7.0-soap php7.0-curl php7.0-zip

        sleep 5
        systemctl restart apache2
        sleep 5
         echo -e "\e[1;34mInstallation prerequisite\e[0m"
#creation  system folder

       for (( i=1; i<=40; i++ ));
        do
                mkdir -p /datastore/streamerdata/SPL/srv_$i
        done

        mkdir -p /datastore/dockers-config
        mkdir -p /datastore/K/Shared
        mkdir -p /datastore/KDM
        mkdir -p /datastore/kdm_import_ftp
        mkdir -p /media/$(whoami)
        mkdir -p /media/$SUDO_USER
        chown -R $SUDO_USER.$SUDO_USER /datastore
        chown -R $SUDO_USER.$SUDO_USER /media/$SUDO_USER
        chmod -R 777 /datastore
        chmod -R 777 /media

        echo -e "\e[1;34mEND Installation prerequisite\e[0m"
        sleep 5
}



config_mysql() {
	sed -i "s/$ADDRESS_KEY/$COMMENT_ADDRESS_KEY/g" $CONFIG_FILE
	sed -i "s/$EXTERNAL_LOCKING/$COMMENT_EXTERNAL_LOCKING/g" $CONFIG_FILE


	echo skip-name-resolve >> $CONFIG_FILE
	echo sql-mode=\"ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION\" >> $CONFIG_FILE
    echo lower_case_table_names=1 >> $CONFIG_FILE
	
	dialog --insecure --title "Mysql Configuration" --passwordbox "Enter mysql password" 8 50  2>$TEMP
	retv=$?
	MYSQL_PASSWORD=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1
	
	dialog --infobox "Configuring Streamer Database, please wait" 3 34
	
	mysql -u root --password=$MYSQL_PASSWORD -e "GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' IDENTIFIED BY '$MYSQL_PASSWORD' WITH GRANT OPTION;" &> /dev/null
	
	systemctl restart mysql
	
	#echo -e "\e[1;34mInstallation successful\e[0m"
}


install_mysql() {

DB="cinecloud"

if [ $(dpkg-query -W -f='${Status}' mysql-client 2>/dev/null | grep -c "ok installed") -eq 0 ];
then
  apt-get install -y -f mysql-client; sleep 5
else
	dialog --infobox "Mysql Client Already Installed" 3 34; sleep 5
fi

if [ $(dpkg-query -W -f='${Status}' mysql-server 2>/dev/null | grep -c "ok installed") -eq 0 ];
then
  apt-get install -y -f mysql-server; sleep 5
else
	dialog --infobox "Mysql Server Already Installed" 3 34; sleep 5
fi

dialog --insecure --title "Mysql Configuration" --passwordbox "Enter mysql password" 8 50  2>$TEMP
retv=$?
MYSQL_PASSWORD=$(cat $TEMP)
[ $retv -eq 1 -o $retv -eq 255 ] && return 1

output=$(mysql -u root --password=${MYSQL_PASSWORD} -s -N -e "SELECT schema_name FROM information_schema.schemata WHERE schema_name = '${DB}'" information_schema)
if [[ -z "${output}" ]]; then
	sed -i "s/$ADDRESS_KEY/$COMMENT_ADDRESS_KEY/g" $CONFIG_FILE
	sed -i "s/$EXTERNAL_LOCKING/$COMMENT_EXTERNAL_LOCKING/g" $CONFIG_FILE


	echo skip-name-resolve >> $CONFIG_FILE
	echo sql-mode=\"ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION\" >> $CONFIG_FILE
	mysql -u root --password=$MYSQL_PASSWORD -e "GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' IDENTIFIED BY '$MYSQL_PASSWORD' WITH GRANT OPTION;" &> /dev/null
	
	systemctl restart mysql
else
	dialog --infobox "Mysql Database Already Installed" 3 50; sleep 5
fi 
 
}

install_ftp() {
	
if [ $(dpkg-query -W -f='${Status}' proftpd 2>/dev/null | grep -c "ok installed") -eq 0 ];
then
	apt-get -qq install -y proftpd;
	sed -i "/$DEFAULT_FTP_ROOT/s/^#//" $PROFTPD_CONFIG_FILE
	sed -i "/$DEFAULT_FTP_ROOT_SPACE/s/^\s//g" $PROFTPD_CONFIG_FILE
	#sed -i "s/\(\#\s*$TARGET_KEY \s*=\s*\).*/\1$REPLACEMENT_VALUE/" $CONFIG_FILE   
	sed -i "s#\($DEFAULT_FTP_ROOT_SPACE\s*\).*#\1$REPLACE_DEFAULT_FTP_ROOT#" $PROFTPD_CONFIG_FILE
	sed -i "/$DEFAULT_FTP_ROOT_SPACE/i UseReverseDNS                   off" $PROFTPD_CONFIG_FILE
	systemctl restart proftpd
else
	dialog --infobox "Ftp Server Already Installed" 3 34; sleep 5
fi
}

install_webmin() {
dialog --infobox "Start Webmin Install..." 3 34; sleep 10
if [ $(dpkg-query -W -f='${Status}' webmin 2>/dev/null | grep -c "ok installed") -eq 0 ];
then
	dialog --infobox "Start Webmin Install, please wait" 3 34
	echo deb http://download.webmin.com/download/repository sarge contrib >> /etc/apt/sources.list
	
	(
	wget http://www.webmin.com/jcameron-key.asc |
	while IFS= read -r line
	  do
	  dialog --infobox "Download webmin keys, please wait" 3 34
	  done
	)  
	(
	sudo apt-key add jcameron-key.asc  |
	while IFS= read -r line
	  do
	  dialog --infobox "Update webmin keys, please wait" 3 34
	  done
	)  
	
	(
	apt-get update  |
	while IFS= read -r line
	  do
	  dialog --infobox "Update System, please wait" 3 34
	  done
	)  
	
	(
	apt-get install -y webmin  |
	while IFS= read -r line
	  do
	   dialog --infobox "Installing Webmin, please wait" 3 34
	  done
	)
else
	dialog --infobox "Webmin Already Installed" 3 34; sleep 5
		
fi
}


# OK 20191220
install_docker_daemon() {
	
if [ $(dpkg-query -W -f='${Status}' docker-ce 2>/dev/null | grep -c "ok installed") -eq 0 ];
then
	curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo apt-key add -> /dev/null
	add-apt-repository "deb [arch=amd64] https://download.docker.com/linux/ubuntu bionic stable"
	(
		apt-get update  |
		while IFS= read -r line
		  do
		  dialog --infobox "Update System, please wait" 3 34
		  done
	) 	
	(
	apt-get install -y docker-ce |
		
		while IFS= read -r line
		  do
		  dialog --infobox "Installing Docker daemon, please wait" 3 34
		  done
		) 
	sed -i "s#\($DOCKER_START=\).*#\1$DOCKER_START_REPLACE#" $DOCKER_CONFIG_FILE
	
	
	systemctl daemon-reload && systemctl restart docker
        ## Create a network  net-cineplayer                                                                               
        docker -H :3000 network create --driver=bridge --subnet=172.18.0.0/16 --gateway=172.18.0.1 net-cineplayer
else
	dialog --infobox "Docker Engine Already Installed" 3 50; sleep 5
		
fi		
	
}

#20191220
install_docker_ui() {
if [ $(dpkg-query -W -f='${Status}' docker-ce 2>/dev/null | grep -c "ok installed") -eq 1 ];
then
	output=$(docker -H :3000 images | grep portainer)
	if [[ -z "${output}" ]]; then
		docker -H :3000 volume create --name portainer_data --label portainer_data >/dev/null
		docker -H :3000 load -i $PWD/dockersUI/portainer.tar >/dev/null
		docker -H :3000 run -d -p 9000:9000 --restart="always" -v /var/run/docker.sock:/var/run/docker.sock -v portainer_data:/data portainer/portainer >/dev/null
	fi
else
	dialog --infobox "Docker Engine Not Installed" 3 34; sleep 5
fi
	
}

#OK 20191220
install_nfs() {
if [ $(dpkg-query -W -f='${Status}' nfs-kernel-server 2>/dev/null | grep -c "ok installed") -eq 0 ];
then
	(
	apt-get install -y nfs-kernel-server samba |
	while IFS= read -r line
	  do
	   dialog --infobox "Installing Nfs Server, please wait" 3 34
	  done
	)


	dialog --title "NFS Management Network" --inputbox  "Enter IP Management Network" 8 50  2>$TEMP

	retv=$?
	MANAGE_IP=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1
	
	IFS='.' read -r -a arraym <<< "$MANAGE_IP"

	MANAGE_NET="/datastore       ${arraym[0]}.${arraym[1]}.${arraym[2]}.0/24(rw,sync,no_subtree_check)"


	dialog --title "NFS Data Network" --inputbox  "Enter IP Data Network" 8 50  2>$TEMP
	retv=$?
	DATA_IP=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1
	IFS='.' read -r -a arrayd <<< "$DATA_IP"

	DATA_NET="/datastore       ${arrayd[0]}.${arrayd[1]}.${arrayd[2]}.0/24(rw,sync,no_subtree_check)"

	
	if [ "$MANAGE_NET" == "$DATA_NET" ]; then
		echo $MANAGE_NET >> $EXPORTS_FILE
	else
		echo $MANAGE_NET >> $EXPORTS_FILE
		echo $DATA_NET >> $EXPORTS_FILE
	fi
	
	
	dialog --title "Samba User" --inputbox  "Enter Samba User Name" 8 50  2>$TEMP

	retv=$?
	SAMBA_USER=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1

	dialog --insecure --title "Samba Password" --passwordbox "Enter Samba password" 8 50  2>$TEMP
	
	retv=$?
	SAMBA_PASSWORD=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1
	
	echo -e "$SAMBA_PASSWORD\n$SAMBA_PASSWORD" | (smbpasswd -a -s $SAMBA_USER)
	smbd reload
	
	echo "[datastore]" >> $SAMBA_CONFIG_FILE
	echo "path = /datastore" >> $SAMBA_CONFIG_FILE
	echo "valid users = $SAMBA_USER" >> $SAMBA_CONFIG_FILE
	echo "read only = no" >> $SAMBA_CONFIG_FILE
	echo "writeable = yes" >> $SAMBA_CONFIG_FILE
	echo "browseable = yes" >> $SAMBA_CONFIG_FILE
	echo "public = yes" >> $SAMBA_CONFIG_FILE
	echo "directory mask = 2777"  >> $SAMBA_CONFIG_FILE
	echo "force directory mode = 2777"   >> $SAMBA_CONFIG_FILE
	echo "directory security mask = 2777"  >> $SAMBA_CONFIG_FILE
	echo "force directory security mode = 2777"  >> $SAMBA_CONFIG_FILE	
	
	systemctl restart smbd
	
	exportfs -rva &> /dev/null
	systemctl restart nfs-kernel-server
	systemctl restart nfs-idmapd

else
	dialog --infobox "NFS/SAMBA Already Installed" 3 34; sleep 5
fi



}

change_root_password() {
	while :
	do
	dialog --insecure --title "Root Password" --passwordbox  "Enter root password" 8 50  2>$TEMP
	retv=$?
	ROOT_PWD=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1

	dialog --insecure --title "Root Password" --passwordbox "Enter again root password" 8 50  2>$TEMP
	retv=$?
	RETYPE_ROOT_PWD=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1

	if [ "$ROOT_PWD" == "$RETYPE_ROOT_PWD" ]; then
		echo -e "$ROOT_PWD\n$RETYPE_ROOT_PWD" | passwd root &> /dev/null
		dialog --infobox "Root password successfully changed" 3 50 ; sleep 5
		break
	else
		dialog --infobox "Error inserting root password" 3 50 ; sleep 5
	fi
	done
	
	sed -i "s#\($SSH_PERMIT\s\).*#\1$SSH_PERMIT_REPLACE#" $SSH_CONFIG_FILE

	systemctl restart ssh

	ssh-keygen -f /root/.ssh/id_rsa -t rsa -N ''
	#ssh-keygen -f /home/$SUDO_USER/.ssh/id_rsa -t rsa -N ''
	#chown -R $SUDO_USER.$SUDO_USER ~/.ssh
	for (( i=1; i<=$THEATER_NUMBER; i++ ));
    do 
		mkdir -p /datastore/streamerdata/SPL/srv_$i
	done
	
	mkdir -p /datastore/dockers-config
	mkdir -p /datastore/k/Shared
	mkdir -p /media/$(whoami)
	mkdir -p /media/$SUDO_USER
	chown -R $SUDO_USER.$SUDO_USER /datastore
	chown -R $SUDO_USER.$SUDO_USER /media/$SUDO_USER
	chmod -R 777 /datastore
	chmod -R 777 /media
}


config_keys(){

	PASSWORD=$1
	IP=$2

	ssh-keyscan -H $IP >> /root/.ssh/known_hosts
	#ssh-keyscan -H $IP >> /home/$SUDO_USER/.ssh/known_hosts

	cat /root/.ssh/id_rsa.pub | sshpass -p $PASSWORD ssh root@$IP  "mkdir -p /root/.ssh && chmod 700 /root/.ssh && cat >>  /root/.ssh/authorized_keys"
	#cat /home/$SUDO_USER/.ssh/id_rsa.pub | sshpass -p $PASSWORD ssh root@$IP  "mkdir -p /home/$SUDO_USER/.ssh && chmod 700 /home/$SUDO_USER/.ssh && cat >>  /home/$SUDO_USER/.ssh/authorized_keys"
}


config_lsync() {

	mkdir -p /etc/lsyncd
	touch /etc/lsyncd/lsyncd.conf.lua
	mkdir -p /var/log/lsyncd
	touch /var/log/lsyncd/lsyncd.log
	touch /var/log/lsyncd/lsyncd.status
		
	echo "settings{" >> $LSYNCD_CONFIG
	echo "		logfile =\"/var/log/lsyncd/lsyncd.log\"," >> $LSYNCD_CONFIG
	echo "		statusFile = \"/var/log/lsyncd/lsyncd.status\"" >> $LSYNCD_CONFIG
	echo "}"  >> $LSYNCD_CONFIG

	echo "servers = {"  >> $LSYNCD_CONFIG


	DATASTORES=()	
	while :
	do
		dialog --title "Lsync datastore" --inputbox  "Enter Datastore IP to Syncronize" 8 50  2>$TEMP
		retv=$?
		DATASTORES+=($(cat $TEMP))
		[ $retv -eq 1 -o $retv -eq 255 ] && return 1
		dialog --title "Confirmation"  --yesno "Any More Datastore to Syncronize ?" 0 0
		retv=$?
		if [ $retv -eq 1 -o $retv -eq 255 ]; then
			break
		fi
	done
	
	counter=0
	for (( i=0; i<${#DATASTORES[@]}; i++ ));
    do      
		datastore=${DATASTORES[$i]}
		((counter+=1))
		if [ ${#DATASTORES[@]} == $counter ]; then
			echo "\"$datastore\"" >> $LSYNCD_CONFIG
			config_keys $ROOT_PWD $datastore
		else
			echo "\"$datastore\"," >> $LSYNCD_CONFIG
			config_keys $ROOT_PWD $datastore
		fi
	done
	
	echo "}" >> $LSYNCD_CONFIG

	echo "for _, server in ipairs(servers)do" >> $LSYNCD_CONFIG

	echo "sync{" >> $LSYNCD_CONFIG
	echo "		default.rsyncssh," >> $LSYNCD_CONFIG
	echo "		source=\"/datastore\"," >> $LSYNCD_CONFIG
	echo "		host = server," >> $LSYNCD_CONFIG
	echo "		targetdir=\"/datastore\"," >> $LSYNCD_CONFIG
	echo "	exclude = {\"streamerdata*\",\"k*\",\"dockers-config*\"}," >> $LSYNCD_CONFIG
	echo "rsync = {" >> $LSYNCD_CONFIG
	echo " archive = true," >> $LSYNCD_CONFIG
	echo " perms = true," >> $LSYNCD_CONFIG
	echo " owner = true," >> $LSYNCD_CONFIG
	echo " _extra = {\"-a\"}, " >> $LSYNCD_CONFIG
	echo " }" >> $LSYNCD_CONFIG
	echo "}" >> $LSYNCD_CONFIG
	echo "end" >> $LSYNCD_CONFIG
	
	systemctl enable lsyncd &> /dev/null
	systemctl restart lsyncd
}



install_lsync() {
if [ $(dpkg-query -W -f='${Status}' lsyncd 2>/dev/null | grep -c "ok installed") -eq 0 ];
then

	dialog --infobox "Install Lsyncd packages, please wait" 3 50
	(
	apt-get -qq install -y \
		lsyncd |
		
		while IFS= read -r line
		  do
		  dialog --infobox "Install Lsyncd packages, please wait" 3 34
		  done
	) 
	dialog --title "Theater's Number" --inputbox  "Enter the maximum theater number installed [e.g 1 2 3 ...]" 8 50  2>$TEMP

	retv=$?
	THEATER_NUMBER=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1

	change_root_password
	config_lsync	
fi
}


install_usbmount() {

if [ $(dpkg-query -W -f='${Status}' udisks2 2>/dev/null | grep -c "ok installed") -eq 0 ];
then
	(
	apt-get install -y udisks2  |
	while IFS= read -r line
	  do
	   dialog --infobox "Installing Udisks 2 Control, please wait" 3 34
	  done
	)
else
	dialog --infobox "Udisks2 Already Installed" 3 34; sleep 5
fi

output=$(ls -l /usr/local/bin | grep usb-mount.sh)
if [[ -z "${output}" ]]; then
	dialog --infobox "Installing Usb Mount Scripts" 3 34
	cp $PWD/usbmount/bash-logger.sh /usr/local/bin
	cp $PWD/usbmount/*.rules /etc/udev/rules.d
	cp $PWD/usbmount/usb-mount.sh /usr/local/bin
	cp $PWD/usbmount/usb-mount-sleep.sh /usr/local/bin
	cp $PWD/usbmount/usb-mount@.service /etc/systemd/system
	
	udevadm control -l debug
	udevadm control --reload-rules
else
	dialog --infobox "Usbmont Already Installed" 3 34; sleep 5
fi


}

install_streamer(){
DIRECTORY="/var/www/html/Streamer"

if [ $(dpkg-query -W -f='${Status}' php7.0 2>/dev/null | grep -c "ok installed") -eq 0 ];
then
	dialog --infobox "Installing Apache2 / Php Packages, please wait" 3 34
	(
	apt-get -qq install -y \
		apache2 \
		php7.0 \
		libapache2-mod-php7.0 \
		php7.0-mcrypt \
		php7.0-mysql \
		php7.0-xml \
		php7.0-dev \
		php-ssh2    |
		
		while IFS= read -r line
		  do
		  dialog --infobox "Install packages, please wait" 3 34
		  done
		) 
fi



if [ ! -d "$DIRECTORY" ]; then
	CURRENT_PATH=$PWD
	PHP_LIB_PATH=$(php-config --extension-dir)
	tar -xzvf $PWD/ioncube/ioncube_loaders_lin_x86-64.tar.gz >/dev/null
	cp $PWD/ioncube/*.so $PHP_LIB_PATH

	touch /etc/php/7.0/mods-available/00-ioncube.ini
	echo "zend_extension = $PHP_LIB_PATH/ioncube_loader_lin_7.0.so" >> /etc/php/7.0/mods-available/00-ioncube.ini
	cd 	/etc/php/7.0/apache2/conf.d
	ln -s /etc/php/7.0/mods-available/00-ioncube.ini 00-ioncube.ini
	cd /etc/php/7.0/cli/conf.d
	ln -s /etc/php/7.0/mods-available/00-ioncube.ini 00-ioncube.ini
	
	cd $CURRENT_PATH
	
#	tar -xzvf $PWD/Streamer/Streamer.tar.gz -C /var/www/html &> /dev/null
	
	chown -R www-data.www-data /var/www/html
	
	systemctl restart apache2
       
        wget http://software.bitonlive.net/cinema/Setup/InstallDatastore/dockers/CinePlayout/install-cineplayout.sh
        chmod +x install-cineplayout.sh

        wget http://software.bitonlive.net/cinema/Setup/InstallDatastore/dockers/install-store-hula.sh
        chmod x install-store-hula.sh

        wget http://www.software.bitonlive.net/cinema/Setup/InstallDatastore/dockers/CinePlayout/install-mountmanager.sh
        chmod +x install-mountmanager.sh

        wget http://software.bitonlive.net/cinema/Setup/InstallDatastore/dockers/Streamer/install-streamer.sh
        chmod +x install-streamer.sh
        ./install-streamer.sh

        wget http://software.bitonlive.net/cinema/Setup/InstallDatastore/index.txt
        rm /var/www/html/index.*
        mv index.txt /var/www/html/index.php


        echo "MaxSessions 100" >> $SSH_CONFIG_FILE        
else
	dialog --infobox "PHP Library Already Installed" 3 34; sleep 5
fi
}

config_docker_daemon() {

	curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo apt-key add -> /dev/null
	add-apt-repository "deb [arch=amd64] https://download.docker.com/linux/ubuntu bionic stable"
	(
		apt-get update  |
		while IFS= read -r line
		  do
		  dialog --infobox "Update System, please wait" 3 34
		  done
	) 	
	(
	apt-get install -y docker-ce |
		
		while IFS= read -r line
		  do
		  dialog --infobox "Installing Docker daemon, please wait" 3 34
		  done
		) 
	sed -i "s#\($DOCKER_START=\).*#\1$DOCKER_START_REPLACE#" $DOCKER_CONFIG_FILE
	
	
	systemctl daemon-reload && systemctl restart docker
	
	docker -H :3000 volume create --name portainer_data --label portainer_data >/dev/null
	
	docker -H :3000 load -i $PWD/dockersUI/portainer.tar >/dev/null
	
	docker -H :3000 run -d -p 9000:9000 --restart="always" -v /var/run/docker.sock:/var/run/docker.sock -v portainer_data:/data portainer/portainer >/dev/null
	
	
}

config_nfs() {

	dialog --title "NFS Management Network" --inputbox  "Enter IP Management Network" 8 50  2>$TEMP

	retv=$?
	MANAGE_IP=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1

	
	IFS='.' read -r -a arraym <<< "$MANAGE_IP"

	MANAGE_NET="/datastore       ${arraym[0]}.${arraym[1]}.${arraym[2]}.0/24(rw,sync,no_subtree_check)"


	dialog --title "NFS Data Network" --inputbox  "Enter IP Data Network" 8 50  2>$TEMP
	retv=$?
	DATA_IP=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1
	IFS='.' read -r -a arrayd <<< "$DATA_IP"

	DATA_NET="/datastore       ${arrayd[0]}.${arrayd[1]}.${arrayd[2]}.0/24(rw,sync,no_subtree_check)"

	
	if [ "$MANAGE_NET" == "$DATA_NET" ]; then
		echo $MANAGE_NET >> $EXPORTS_FILE
	else
		echo $MANAGE_NET >> $EXPORTS_FILE
		echo $DATA_NET >> $EXPORTS_FILE
	fi
	
	
	dialog --title "Samba User" --inputbox  "Enter Samba User Name" 8 50  2>$TEMP

	retv=$?
	SAMBA_USER=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1

	dialog --insecure --title "Samba Password" --passwordbox "Enter Samba password" 8 50  2>$TEMP
	
	retv=$?
	SAMBA_PASSWORD=$(cat $TEMP)
	[ $retv -eq 1 -o $retv -eq 255 ] && return 1
	
	echo -e "$SAMBA_PASSWORD\n$SAMBA_PASSWORD" | (smbpasswd -a -s $SAMBA_USER)
	smbd reload
	
	echo "[datastore]" >> $SAMBA_CONFIG_FILE
	echo "path = /datastore" >> $SAMBA_CONFIG_FILE
	echo "valid users = $SAMBA_USER" >> $SAMBA_CONFIG_FILE
	echo "read only = no" >> $SAMBA_CONFIG_FILE
	echo "writeable = yes" >> $SAMBA_CONFIG_FILE
	echo "browseable = yes" >> $SAMBA_CONFIG_FILE
	echo "public = yes" >> $SAMBA_CONFIG_FILE
	echo "directory mask = 2777"  >> $SAMBA_CONFIG_FILE
	echo "force directory mode = 2777"   >> $SAMBA_CONFIG_FILE
	echo "directory security mask = 2777"  >> $SAMBA_CONFIG_FILE
	echo "force directory security mode = 2777"  >> $SAMBA_CONFIG_FILE	
	
	systemctl restart smbd
	
	exportfs -rva &> /dev/null
	systemctl restart nfs-kernel-server
	systemctl restart nfs-idmapd
}


config_usbmount() {
	
	dialog --infobox "Installing Usb Mount Scripts" 3 34
	cp $PWD/usbmount/bash-logger.sh /usr/local/bin
	cp $PWD/usbmount/*.rules /etc/udev/rules.d
	cp $PWD/usbmount/usb-mount.sh /usr/local/bin
	cp $PWD/usbmount/usb-mount-sleep.sh /usr/local/bin
	cp $PWD/usbmount/usb-mount@.service /etc/systemd/system
	
	udevadm control -l debug
	udevadm control --reload-rules
}



config_proftpd() {

		sed -i "/$DEFAULT_FTP_ROOT/s/^#//" $PROFTPD_CONFIG_FILE
		sed -i "/$DEFAULT_FTP_ROOT_SPACE/s/^\s//g" $PROFTPD_CONFIG_FILE
		#sed -i "s/\(\#\s*$TARGET_KEY \s*=\s*\).*/\1$REPLACEMENT_VALUE/" $CONFIG_FILE   
		sed -i "s#\($DEFAULT_FTP_ROOT_SPACE\s*\).*#\1$REPLACE_DEFAULT_FTP_ROOT#" $PROFTPD_CONFIG_FILE
		sed -i "/$DEFAULT_FTP_ROOT_SPACE/i UseReverseDNS                   off" $PROFTPD_CONFIG_FILE
        
        systemctl restart proftpd
}

clean_up() {
  clear
  rm -f $TEMP
  exit
}
clean_up_no_exit() {
  clear
}

check_internet() {
	dialog --infobox "Checking Internet connection" 3 34 ; sleep 5
	
	if ping -q -c 1 -W 1 google.com >/dev/null; then
	  dialog --infobox "Iternet Connection is UP" 3 34 ; sleep 5
	else
	  dialog --infobox "Internet Connection is DOWN" 3 34
	  exit
	fi
}

check_internet_no_dialog() {
	
	if ping -q -c 1 -W 1 google.com >/dev/null; then
	  echo -e "\e[1;34mStart Installation Updating System Source List\e[0m" ; sleep 5
	  apt-get update
	else
	  echo -e "\e[1;31mInternet Connection is DOWN\e[0m"
	  exit
	fi
}


main_menu() {

  dialog --title "Select Datastore functionality to install" \
  --checklist "Choose one or more functionality:" 18 60 16 \
  1 "MYSQL Streamer Client/Server"          off \
  2 "FTP Server"    off \
  3 "Webmin"     off \
  4 "Docker Daemon"     off \
  5 "Docker Web UI"     off \
  6 "NFS/Samba"     off \
  7 "Lsync"     off \
  8 "Usbmount"     off \
  9 "Streamer"     off 2>$TEMP

  if [ "$?" != "0" ] ; then return ; fi

  choices=$(cat $TEMP)
  for choice in $choices
  do
    case $choice in
      1) install_mysql;;
      2) install_ftp;;
      3) install_webmin;;
      4) install_docker_daemon;;
      5) install_docker_ui;;
      6) install_nfs;;
      7) install_lsync;;
      8) install_usbmount;;
      9) install_streamer;;

    esac
  done

}


check_internet_no_dialog
apt-get -qq install -y dialog

check_internet

echo -e "\e[1;34mInstallation prerequisite\e[0m"

install_prerequisite

main_menu

clean_up_no_exit

echo -e "\e[1;34mInstallation successful\e[0m"
